/*******************************************************
Filename		:  FA_BIO_RESULT_data2.sql
Release 		:  c2.0
SIR			:  1495
Description		:  Adds additional data element to the FA_BIOLOGICAL_RESULT fact table.
Author			:  Christine Tsang
Date			:  7/8/2003
                     	   7/29/2003 - changed update for EPA reg #.
                     	   8/13/2003 - added logic to set activity attributes for 'Composite-with Parents' samples.
                     	   8/13/2003 - Separated update of non-sti subject taxons from the other fields.
                     8/26/2003 - SIR 1495 TIR#4 - Corrected updates of net tow and net non-tow.
                                 TIR#5 - Modified code for common_class_desc.
                                 TIR#6 - Modified code for characteristic_name.  
Comments		:  Run this script after create_bio_temp_tables.sql.
**********************************************************/
spool FA_BIOLOGICAL_RESULT_data2.log

connect storetw/storetw@storet.sdc
set serveroutput on
set time on

prompt "PARTICLE SIZE"
UPDATE FA_BIOLOGICAL_RESULT RE 
SET PARTICLE_SIZE =
     (SELECT RCI.PARTICLE_SIZE_BASIS
      FROM storet1.TSRRCI RCI
	WHERE re.result_is_number = RCI.TSRRSULT_IS_NUMBER
	AND re.ORGANIZATION_ID = RCI.TSRRSULT_ORG_ID);
commit;

prompt "trip and station visit info"
UPDATE FA_BIOLOGICAL_RESULT RE 
SET (STATION_ID,STATION_NAME,TRIP_ID,TRIP_NAME,STATION_VISIT_ID,TSMSTATN_IS_NUMBER,
     VISIT_START_DATE_TIME,VISIT_START_TIME_ZONE,VISIT_STOP_DATE_TIME,VISIT_STOP_TIME_ZONE) =
(SELECT st.STATION_ID,st.STATION_NAME,st.TRIP_ID,st.TRIP_NAME,st.STATION_VISIT_ID,st.TSMSTATN_IS_NUMBER,
	st.VISIT_START_DATE_TIME,st.VISIT_START_TIME_ZONE,st.VISIT_STOP_DATE_TIME,st.VISIT_STOP_TIME_ZONE	
  	from statninfo_temp st
  	WHERE re.TSRSTVST_IS_NUMBER = ST.TSRSTVST_IS_NUMBER
	AND re.ORGANIZATION_ID = ST.TSRSTVST_ORG_ID);
commit;

prompt "STATION and STATION LOCATION INFO"
update FA_BIOLOGICAL_RESULT re set (fk_station,
		re.fk_org, 
		re.fk_db_cat,
		re.fk_geo_county,
		re.fk_geo_state,
		re.stn_latitude,
		re.stn_longitude,
		re.hydrologic_unit_code,
		re.sgo_indicator)=
	(select st.pk_isn,
		st.fk_org,
		st.fk_db_cat,
		st.fk_geo_county,
		st.fk_geo_state,
		st.latitude,
		st.longitude,
		st.hydrologic_unit_code,
		st.sgo_indicator
	from fa_station st
	where st.organization_id = re.organization_id
	and st.station_is_number = re.tsmstatn_is_number
	and st.location_point_type = '*POINT OF RECORD');
commit;

prompt "RESULT UOM"
UPDATE FA_BIOLOGICAL_RESULT RE SET RESULT_UNIT =
	(SELECT RSLTUOM.SHORT_FORM_NAME
	FROM storet.TSRUOM RSLTUOM
	WHERE re.TSRUOM_IS_NUMBER = RSLTUOM.TSRUOM_IS_NUMBER
  	AND re.TSRUOM_ORG_ID = RSLTUOM.TSRUOM_ORG_ID);
commit;


prompt "activity attributes"
update FA_BIOLOGICAL_RESULT RE
set (LOCATION_POINT_TYPE    ,
POINT_SEQUENCE_NUMBER  ,
WELL_NUMBER            ,
PIPE_NUMBER            ,
ACTIVITY_LATITUDE      ,
ACTIVITY_LONGITUDE     ,
FK_ACT_MAD_HDATUM      ,
FK_ACT_MAD_HMETHOD     ,
activity_isn		,
POINT_NAME			,
MAP_SCALE,
TR_START_POINT_NAME,
TR_START_LATITUDE,
TR_START_LONGITUDE,
TR_START_DEPTH,
TR_STOP_POINT_NAME,
TR_STOP_LATITUDE,
TR_STOP_LONGITUDE,
TR_STOP_DEPTH) = 
(select b.LOCATION_POINT_TYPE    ,
b.POINT_SEQUENCE_NUMBER  ,
b.WELL_NUMBER            ,
b.PIPE_NUMBER            ,
b.ACTIVITY_LATITUDE      ,
b.ACTIVITY_LONGITUDE     ,
b.FK_ACT_MAD_HDATUM      ,
b.FK_ACT_MAD_HMETHOD     ,
b.activity_isn		,
b.POINT_NAME			,
b.MAP_SCALE,
b.TR_START_POINT_NAME,
b.TR_START_LATITUDE,
b.TR_START_LONGITUDE,
b.TR_START_DEPTH||' '||b.TR_START_DEPTH_UNIT,
b.TR_STOP_POINT_NAME,
b.TR_STOP_LATITUDE,
b.TR_STOP_LONGITUDE,
b.TR_STOP_DEPTH||' '||b.TR_STOP_DEPTH_UNIT 
from biofdact_temp2 b
where re.activity_is_number = b.activity_is_number
and  re.organization_id = b.organization_id);
commit;

prompt "activity attributes for Composite-with Parents"
update FA_BIOLOGICAL_RESULT re 
set (re.location_point_type,
     re.point_sequence_number,
     re.point_name,
     re.activity_latitude,
     re.activity_longitude,
     re.map_scale,
     re.fk_act_mad_hdatum,
     re.fk_act_mad_hmethod) =
  (select st.location_point_type,
     st.point_sequence_number,
     st.point_name,
     st.latitude,
     st.longitude,
     st.map_scale,
     st.fk_mad_hdatum,
     st.fk_mad_hmethod
   from fa_station st
   where st.organization_id = re.organization_id
   and st.station_is_number = re.tsmstatn_is_number
   and st.location_point_type = '*POINT OF RECORD')
where re.activity_category = 'Composite-with Parents';
commit;

prompt "ANALYTICAL PROCEDURE"
UPDATE FA_BIOLOGICAL_RESULT RE SET (ANALYTICAL_PROCEDURE_SOURCE,ANALYTICAL_PROCEDURE_ID) =
	(SELECT ANLPR.SOURCE_ACR,
		ANLPR.PROCEDURE_ID	
	FROM storet1.TSRANLPR ANLPR
	WHERE re.TSRANLPR_IS_NUMBER = ANLPR.TSRANLPR_IS_NUMBER
	AND re.TSRANLPR_ORG_ID = ANLPR.TSRANLPR_ORG_ID)
WHERE re.TSRANLPR_IS_NUMBER IS NOT NULL;
commit;

/**
prompt "SAMPLE PREP"
UPDATE FA_BIOLOGICAL_RESULT RE SET (SAMPLE_PREP_SOURCE,SAMPLE_PREP_NAME) =
	(SELECT LSPP.SOURCE_ACR,
		LSPP.NAME
	FROM storet1.TSRLSPP LSPP
	WHERE re.TSRLSPP_IS_NUMBER = LSPP.TSRLSPP_IS_NUMBER
	AND re.TSRLSPP_ORG_ID = LSPP.TSRLSPP_ORG_ID);
commit;
**/

prompt "LAB"
UPDATE FA_BIOLOGICAL_RESULT RE SET (LAB_ID,LAB_NAME) =
	(SELECT LAB.ID_CODE,
		LAB.NAME
	FROM storet1.TSRLAB LAB
	WHERE re.TSRLAB_IS_NUMBER = LAB.TSRLAB_IS_NUMBER
	AND re.ORGANIZATION_ID= LAB.TSRLAB_ORG_ID)
WHERE re.TSRLAB_IS_NUMBER IS NOT NULL;
commit;

prompt "QUANT LIMITS"
UPDATE FA_BIOLOGICAL_RESULT RE SET (LOWER_QUANTITATION_LIMIT,UPPER_QUANTITATION_LIMIT,DETECTION_LIMIT,
 	DETECTION_LIMIT_DESCRIPTION) =
 	(SELECT DQL.MIN_QUANT_LIMIT,
  		DQL.MAX_QUANT_LIMIT,
  		DQL.MIN_DETECT_LIMIT||' '||UOM.SHORT_FORM_NAME,
  		DQL.DESCRIPTION_TEXT
 	FROM storet1.TSRDQL DQL, storet.TSRUOM UOM
 	WHERE re.RESULT_IS_NUMBER = DQL.TSRRSULT_IS_NUMBER
 		AND re.ORGANIZATION_ID = DQL.TSRRSULT_ORG_ID
 		AND DQL.TSRUOM_IS_NUMBER = UOM.TSRUOM_IS_NUMBER(+)
 		AND DQL.TSRUOM_ORG_ID = UOM.TSRUOM_ORG_ID(+))
--            AND DQL.TSRUOM_IS_NUMBER IS NOT NULL);
commit;

prompt "FK_DATE"
update FA_BIOLOGICAL_RESULT re set fk_date_act_start = (
	select da.pk_isn from di_date da
	where TO_CHAR(re.activity_start_date_time,'DD-MON-YYYY') = da.full_date);
commit;

--new Activity Elements section
prompt "FIELD PROCEDURE"
update FA_BIOLOGICAL_RESULT re
set (field_procedure_id) = (
	select id_code
	from storet1.TSRFLDPR fldpr
	where re.tsrfldpr_is_number = fldpr.tsrfldpr_is_number
	and re.ORGANIZATION_ID = fldpr.tsrfldpr_org_id)
WHERE re.TSRFLDPR_IS_NUMBER IS NOT NULL;
commit;

/**
prompt "SAMPLE"
update FA_BIOLOGICAL_RESULT re
set (container_type,container_color,temperature_presrvtn_type,presrvtn_storage_procedure) = (
	select container_type_nm,container_color,temp_preservn_type,presrv_strge_prcdr
	from storet1.tsrsmple smple
	where re.activity_is_number = smple.tsrfdact_is_number
	and re.organization_id = smple.tsrfdact_org_id);
commit;
**/

prompt "GEAR CONFIG"
update FA_BIOLOGICAL_RESULT re
set (gear_config_id) = (
	select id_code
	from storet1.tsrgrcfg grcfg
	where re.tsrgrcfg_is_number = grcfg.tsrgrcfg_is_number
	and re.ORGANIZATION_ID = grcfg.tsrgrcfg_org_id)
WHERE re.TSRGRCFG_IS_NUMBER IS NOT NULL;
commit;

prompt "FIELD GEAR ID"
update FA_BIOLOGICAL_RESULT re
set (field_gear_id) = (
	select id_code
	from storet.tsrfldgr fldgr
	where re.tsrfldgr_is_number = fldgr.tsrfldgr_is_number)
WHERE re.TSRFLDGR_IS_NUMBER IS NOT NULL;
commit;

/*
prompt "SAMPLE PRES ID"
update FA_BIOLOGICAL_RESULT re
set (sample_pres_id) = (
	select id_code
	from storet1.tsrsdp sdp
      where re.tsrsdp_is_number = sdp.tsrsdp_is_number
        and re.organization_id = sdp.tsrsdp_org_id)
WHERE re.TSRSDP_IS_NUMBER IS NOT NULL;
commit;

prompt "ACTIVITY MATRIX"
update FA_BIOLOGICAL_RESULT re
set (re.activity_matrix) = (
	select matrx.name
	from storet.tsrmatrx matrx
	where re.tsrmatrx_is_number = matrx.tsrmatrx_is_number)
WHERE re.TSRMATRX_IS_NUMBER IS NOT NULL;
commit;
*/

prompt "GNTXT FIELDS"
update FA_BIOLOGICAL_RESULT re
set (re.result_comment) = (
	select description_text
	from storet1.tsmgntxt gntxt
	where gntxt.tsrrsult_org_id = re.organization_id
		AND gntxt.tsrrsult_is_number = re.result_is_number
		AND gntxt.description_name ='RSLTCMNT');
commit;

update FA_BIOLOGICAL_RESULT re
set (re.text_result) = (
	select description_text
	from storet1.tsmgntxt gntxt
	where gntxt.tsrrsult_org_id = re.organization_id
		AND gntxt.tsrrsult_is_number = re.result_is_number
		AND gntxt.description_name ='DESCRIPT');
commit;

prompt " Lab Remarks"
update FA_BIOLOGICAL_RESULT a
set a.LAB_REMARK= (select b.lbrmk from lbrmk_temp b
       where b.tsrrsult_is_number = a.result_is_number
           and b.tsrrsult_org_id = a.organization_id);
commit;

prompt " FIELD SET"
update FA_BIOLOGICAL_RESULT a
set a.field_set= (select b.field_set from biofieldset_temp b
       where a.activity_isn = b.activity_isn);
commit;

prompt " CELL SHAPE AND CELL FORM"
update FA_BIOLOGICAL_RESULT re
set (CELL_FORM, CELL_SHAPE) = (
     select CELL_TYPE_NM,           
            CELL_SHAPE_TYPE_NM     
     from storet1.TSRCLDES b
     where b.tsrrsult_is_number = re.result_is_number 
       and b.tsrrsult_org_id = re.organization_id);
commit;

prompt " SAMPLE FRACTION TYPE (non-legacy data)"
update FA_BIOLOGICAL_RESULT re
set (SAMPLE_FRACTION_TYPE) = (
     select FIELD_VALUE
     from storet.TSMPRMVL b
     where b.tsmprmvl_is_number = re.tsmprmvl_is_number 
           and b.field_name = 'SMPL_FRAC_TYPE_NM'
           and b.table_name = 'TSRRSULT')
WHERE re.TSMPRMVL_IS_NUMBER IS NOT NULL;
commit;

-- changed 08/26/2003
prompt " NET TOW INFO"
update FA_BIOLOGICAL_RESULT re
set (re.fished_duration, re.boat_speed, re.fished_distance, re.trawl_comment) = (
      select to_char(FISHED_DURATN_MSR)||' '||FISHD_DURTN_UNT_CD,
             to_char(BOAT_SPEED_MSR)||' '||BOAT_SPEED_UN_CD,
             to_char(FISHED_DISTANCE)||' '||FISHED_DISTANCE_UN,
             COMMENT_TEXT
      from storet1.TSRTOD t
      where t.tsrfdact_is_number = re.activity_is_number
        and t.tsrfdact_org_id = re.organization_id);
commit;

update FA_BIOLOGICAL_RESULT re
set (re.rel_current_dir, re.rel_wind_dir) = (
      select REL_CURRENT_DIR,
             REL_WIND_DIR
      from storet1.TSRTOD t
      where t.tsrfdact_is_number = re.activity_is_number
        and t.tsrfdact_org_id = re.organization_id)
where re.fished_duration is not null;
commit;

prompt " BASIC ELECTROSHOCK INFO"
update FA_BIOLOGICAL_RESULT re
set (re.voltage_measure, re.current_type_code, re.amperage_measure, re.pass_count, re.pass_length, re.pulse_rate,
     re.electroshock_comment, re.total_energzd_time) = (
      select VOLTAGE_MEASURE,        
             CURRENT_TYPE_CODE,      
             AMPERAGE_MEASURE ,      
             PASS_COUNT       ,      
             to_char(PASS_LENGTH_MSR)||' '||PASS_LENGTH_UN_CD,
             PULSE_RATE_MSR,         
             COMMENT_TEXT,           
             to_char(TOTAL_ENERGZD_TIME)||' '||ENERGZD_TIME_UNITS
      from storet1.TSREOD e
      where e.tsrfdact_is_number = re.activity_is_number
        and e.tsrfdact_org_id = re.organization_id);
commit;

-- changed 08/26/2003
prompt " NET NON-TOW INFO"
update FA_BIOLOGICAL_RESULT re
set (re.sampling_duration, re.orientation_to_current, re.trap_net_comment) = (
      select to_char(SMPLNG_DURATN_MSR)||' '||SMPLNG_DRTN_UNT_CD,
             ORIENTN_TO_CURRENT,
             COMMENT_TEXT
      from storet1.TSRTNOD tn
      where tn.tsrfdact_is_number = re.activity_is_number
        and tn.tsrfdact_org_id = re.organization_id);
commit;

update FA_BIOLOGICAL_RESULT re
set (re.rel_current_dir, re.rel_wind_dir) = (
      select REL_CURRENT_DIR   ,    
             REL_WIND_DIR           
      from storet1.TSRTNOD tn
      where tn.tsrfdact_is_number = re.activity_is_number
        and tn.tsrfdact_org_id = re.organization_id)
where re.sampling_duration is not null;
commit;

-- Changed 8/26/2003 - added species number
prompt "CHAR"
UPDATE FA_BIOLOGICAL_RESULT RE SET CHARACTERISTIC_NAME =
	(SELECT CHR.DISPLAY_NAME||' '||re.SPECIES_NUMBER	
	FROM storet.TSRCHAR CHR
	WHERE re.FK_CHAR = CHR.TSRCHAR_IS_NUMBER
	AND re.TSRCHAR_ORG_ID = CHR.TSRCHAR_ORG_ID);
commit;

-- 08/13/2003
prompt " BIO RESULT GROUP INFO--- non-sti"
update FA_BIOLOGICAL_RESULT re
set (re.bio_group_id, re.bio_group_type, re.bio_group_description,
     re.number_in_group, re.bio_group_count_type, re.phys_bio_indicator, re.group_desc_sex, re.group_desc_lifestage) = (
      select id_code, 
             type_name,
             DESCRIPTION_TEXT,       
             SUMMARY_GRP_COUNT,
             VALUE_TYPE_NAME  ,     
             TYPE_INDICATOR   ,     
             SEX_NAME         ,     
             LIFE_STAGE_NAME       
      from storet1.TSRBRG b
      where re.tsrbrg_is_number = b.tsrbrg_is_number
        and re.organization_id = b.tsrbrg_org_id)
where re.tsrbrg_is_number is not null;
commit;

prompt "BIO RESULT GROUP INFO--- non-sti SUBJECT TAXON"
update FA_BIOLOGICAL_RESULT re
set re.bio_group_subject_txn =
     (select rtrim(f_char_name(b.tsrchar_is_number,'ZZZZZZZZ')||' '||species_number)
      from storet1.TSRBRG b
      where re.tsrbrg_is_number = b.tsrbrg_is_number
        and re.organization_id = b.tsrbrg_org_id)
where re.tsrbrg_is_number is not null
  and re.bio_group_type <> 'Multi-Taxon Population Census';
commit;

prompt " BIO RESULT GROUP INFO--- sti"
update FA_BIOLOGICAL_RESULT re
set (re.bio_group_id, re.bio_group_type, re.bio_group_subject_txn, re.bio_group_description) = (
      select id_code, 
             type_name,
             rtrim(f_char_name(brg.tsrchar_is_number,'ZZZZZZZZ')||' '||species_number),
             DESCRIPTION_TEXT       
      from storet1.TSRBRG brg, storet1.TSRBRGI brgi
      where re.tsrbrgi_is_number = brgi.tsrbrgi_is_number
        and re.organization_id = brgi.tsrbrgi_org_id
        and brg.tsrbrg_is_number = brgi.tsrbrg_is_number
        and brg.tsrbrg_org_id = brgi.tsrbrg_org_id)
where re.tsrbrgi_is_number is not null;
commit;

prompt "SINGLE TAXON FREQUENCY CLASS INFO"
update FA_BIOLOGICAL_RESULT re
set (bio_rci_units, PRIMARY_CLASS_DESC, SECONDARY_CLASS_DESC, LOWER_BOUND_AMOUNT, UPPER_BOUND_AMOUNT)  =
(SELECT short_form_name,
              PRIM_CLASS_DESC        ,
              SEC_CLASS_DESC         ,
              LOWER_BND_AMT          ,
              UPPER_BND_AMT               
     from storet1.TSRRCI a, storet.TSRUOM b
     where a.tsruom_is_number = b.tsruom_is_number
       and a.tsruom_org_id = b.tsruom_org_id
       and re.result_is_number = a.tsrrsult_is_number 
       and re.organization_id = a.tsrrsult_org_id)
where re.phys_bio_indicator in ('P','B');
commit;

-- match definition in the all_bio_group_non_sti_results view
update FA_BIOLOGICAL_RESULT re
set re.characteristic_name = PRIMARY_CLASS_DESC||' '||SECONDARY_CLASS_DESC,
    re.result_unit = 'count'
where re.phys_bio_indicator = 'B';
commit;

-- Changed 8/26/2003
update FA_BIOLOGICAL_RESULT re
set (re.common_class_desc, re.characteristic_name) = (
      select chr.display_name,
             chr.display_name||'  '||re.LOWER_BOUND_AMOUNT||' -> '
                             ||re.UPPER_BOUND_AMOUNT||' '||re.BIO_RCI_UNITS
	FROM storet.TSRCHAR CHR
	WHERE re.FK_CHAR = CHR.TSRCHAR_IS_NUMBER)
where re.phys_bio_indicator = 'P';
commit;

prompt "CHARACTERISTIC ALIASES"
update FA_BIOLOGICAL_RESULT re
set CAS_NUMBER = (
     select NAME 
     from storet.TSRCHALS als 
     where re.fk_char = als.tsrchar_is_number
       and als.type_name = 'CAS NUMBER');
commit;

update FA_BIOLOGICAL_RESULT re
set EPA_REG_NUMBER = (
     select NAME 
     from storet.TSRCHALS als 
     where re.fk_char = als.tsrchar_is_number
       and als.type_name = 'EPA ID (SUBSTANCE REGISTRY)');
commit;

update FA_BIOLOGICAL_RESULT re
set ITIS_NUMBER = (
     select NAME 
     from storet.TSRCHALS als 
     where re.fk_char = als.tsrchar_is_number
       and als.type_name = 'ITIS TAXON SERIAL NUMBER');
commit;

prompt "SAMPLE PRES INFO"
update FA_BIOLOGICAL_RESULT re
set (container_desc,TEMP_PRESERVN_TYPE,presrv_strge_prcdr) = (
	select container_desc,TEMP_PRESERVN_TYPE,SUBSTR(presrv_strge_prcdr,1,256)
	from bio_sample_pres_temp smple
	where re.activity_is_number = smple.tsrfdact_is_number
	and re.organization_id = smple.tsrfdact_org_id);
commit;

spool off